<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/


class CWidgetsWidgetTabs extends CWidget {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $meta = array(
		"type"	=> "7",
		"name"	=> "Tabs",
		"module"	=> array(
			"name"	=> "",
			"id"	=> "",
			"type"	=> "",
		)
	);


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($widget) {

		if (!is_array($widget)) {
			return "";
		}

		$items = $this->module->GetStaticItems($widget);

		if (!is_array($items)) {
			return "";
		}

		global $base;

		foreach ($items as $key => $val) {


			$more = $this->plugins["modules"]->BuildLink(array(
				"type"	=> $val["item_link_type"],
				"link"	=> $val["item_link_link"],
				"module"=> $val["item_link_module"],
				"global"=> $val["item_link_global"]
			));

		

			if ($val["item_link_type"]) {
				$more = $this->tpl->blockReplace(
					"Link",
					array(
						"link"		=> $more,
						"target"	=> $val["item_link_target"],
						"text"		=> $val["item_link_text"],
						"size"		=> $val["item_link_size"],
						"rel"		=> $val["item_link_rel"],
						"style"		=> $val["item_link_style"],
					)
				);
			} else {
				$more = "";
			}

			$items[$key]["link"] = $more;
			$items[$key]["icon"] = $this->tpl->blockReplace($val["item_icon"] ? "Icon" : "NoIcon", $val);
			
		}
		
		return $this->tpl->blockReplace(
			"Main" , 
			array(
				"items"	=> $base->html->table(
					$this->tpl , 
					"",	
					$items
				),
				"tabs"	=> $base->html->table(
					$this->tpl , 
					"Tabs",	
					$items
				)

			),
			$widget ,
			$widget["settings"]
		);

	}
	

}


?>